/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass;

import com.chaosthedude.naturescompass.client.ClientEventHandler;
import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.network.CompassSearchPacket;
import com.chaosthedude.naturescompass.network.RequestSyncPacket;
import com.chaosthedude.naturescompass.network.SyncPacket;
import com.chaosthedude.naturescompass.network.TeleportPacket;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.chaosthedude.naturescompass.util.CompassState;
import java.util.List;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="naturescompass")
public class NaturesCompass {
    public static final String MODID = "naturescompass";
    public static final String NAME = "Nature's Compass";
    public static final String VERSION = "1.8.6";
    public static final Logger logger = LogManager.getLogger((String)"naturescompass");
    public static SimpleChannel network;
    public static NaturesCompassItem naturesCompass;
    public static boolean canTeleport;
    public static List<Biome> allowedBiomes;
    public static NaturesCompass instance;

    public NaturesCompass() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::preInit);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit));
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigHandler.GENERAL_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigHandler.CLIENT_SPEC);
    }

    private void preInit(FMLCommonSetupEvent event) {
        network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, MODID), () -> "1.0", s -> true, s -> true);
        network.registerMessage(0, CompassSearchPacket.class, CompassSearchPacket::toBytes, CompassSearchPacket::new, CompassSearchPacket::handle);
        network.registerMessage(1, TeleportPacket.class, TeleportPacket::toBytes, TeleportPacket::new, TeleportPacket::handle);
        network.registerMessage(2, RequestSyncPacket.class, RequestSyncPacket::toBytes, RequestSyncPacket::new, RequestSyncPacket::handle);
        network.registerMessage(3, SyncPacket.class, SyncPacket::toBytes, SyncPacket::new, SyncPacket::handle);
        allowedBiomes = BiomeUtils.getAllowedBiomes();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        ItemModelsProperties.func_239418_a_((Item)naturesCompass, (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new IItemPropertyGetter(){
            @OnlyIn(value=Dist.CLIENT)
            private double rotation;
            @OnlyIn(value=Dist.CLIENT)
            private double rota;
            @OnlyIn(value=Dist.CLIENT)
            private long lastUpdateTick;

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, ClientWorld world, LivingEntity entityLiving) {
                LivingEntity entity;
                if (entityLiving == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean entityExists = entityLiving != null;
                Object object = entity = entityExists ? entityLiving : stack.func_82836_z();
                if (world == null && entity.field_70170_p instanceof ClientWorld) {
                    world = (ClientWorld)entity.field_70170_p;
                }
                double rotation = entityExists ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)entity);
                double adjusted = Math.PI - (((rotation %= 360.0) - 90.0) * 0.01745329238474369 - this.getAngle(world, (Entity)entity, stack));
                if (entityExists) {
                    adjusted = this.wobble(world, adjusted);
                }
                float f = (float)(adjusted / (Math.PI * 2));
                return MathHelper.func_188207_b((float)f, (float)1.0f);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(ClientWorld world, double amount) {
                if (world.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = world.func_82737_E();
                    double d0 = amount - this.rotation;
                    d0 %= Math.PI * 2;
                    d0 = MathHelper.func_151237_a((double)d0, (double)-1.0, (double)1.0);
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation += this.rota;
                }
                return this.rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getFrameRotation(ItemFrameEntity itemFrame) {
                return MathHelper.func_188209_b((int)(180 + itemFrame.func_174811_aO().func_176736_b() * 90));
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getAngle(ClientWorld world, Entity entity, ItemStack stack) {
                if (stack.func_77973_b() == naturesCompass) {
                    NaturesCompassItem compassItem = (NaturesCompassItem)stack.func_77973_b();
                    BlockPos pos = compassItem.getState(stack) == CompassState.FOUND ? new BlockPos(compassItem.getFoundBiomeX(stack), 0, compassItem.getFoundBiomeZ(stack)) : world.func_239140_u_();
                    return Math.atan2((double)pos.func_177952_p() - entity.func_213303_ch().field_72449_c, (double)pos.func_177958_n() - entity.func_213303_ch().field_72450_a);
                }
                return 0.0;
            }
        });
    }
}

